/**
 * 
 */
package com.ejie.ab18a.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.ab18a.dao.Ab18aKomunesDao;
import com.ejie.ab18a.model.Ab18aKomunesEntidad;
import com.ejie.ab18a.model.Ab18aKomunesMesa;
import com.ejie.ab18a.model.Ab18aKomunesOrgano;
import com.ejie.ab18a.model.Ab18aKomunesPoderAdjudicador;

/**
 * @author XXXX
 * 
 */
@Service(value = "ab18aKomunesService")
public class Ab18aKomunesServiceImpl implements Ab18aKomunesService {

	@Autowired()
	private Ab18aKomunesDao ab18aKomunesDao;

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab18a.service.Ab18aKomunesService#findPoderAdjudicador(com.ejie
	 * .ab18a.model.Ab18aKomunesPoderAdjudicador)
	 */
	public Ab18aKomunesPoderAdjudicador findPoderAdjudicador(Ab18aKomunesPoderAdjudicador poderAdjudicador) {
		return this.ab18aKomunesDao.findPoderAdjudicador(poderAdjudicador);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab18a.service.Ab18aKomunesService#findEntidadTramitadora(com
	 * .ejie.ab18a.model.Ab18aKomunesEntidad)
	 */
	public Ab18aKomunesEntidad findEntidadTramitadora(Ab18aKomunesEntidad entidad) {
		return this.ab18aKomunesDao.findEntidadTramitadora(entidad);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab18a.service.Ab18aKomunesService#findEntidadImpulsora(com.ejie
	 * .ab18a.model.Ab18aKomunesEntidad)
	 */
	public Ab18aKomunesEntidad findEntidadImpulsora(Ab18aKomunesEntidad entidad) {
		return this.ab18aKomunesDao.findEntidadImpulsora(entidad);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab18a.service.Ab18aKomunesService#findOrgano(com.ejie.ab18a.
	 * model.Ab18aKomunesOrgano)
	 */
	public Ab18aKomunesOrgano findOrgano(Ab18aKomunesOrgano organo) {
		return this.ab18aKomunesDao.findOrgano(organo);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab18a.service.Ab18aKomunesService#findMesa(com.ejie.ab18a.model
	 * .Ab18aKomunesMesa)
	 */
	public Ab18aKomunesMesa findMesa(Ab18aKomunesMesa mesa) {
		return this.ab18aKomunesDao.findMesa(mesa);
	}

	@Override
	public boolean comprobarPoderEntidadOrganoCoherente(String idPoder, String idEntidadImpulsora, String idOrgano) throws Exception {
		return this.ab18aKomunesDao.comprobarPoderEntidadOrganoCoherente(idPoder, idEntidadImpulsora, idOrgano);
	}

	@Override
	public boolean comprobarEntidadMesaCoherente(String idEntidadTramitadora, String idMesa) {
		return this.ab18aKomunesDao.comprobarEntidadMesaCoherente(idEntidadTramitadora, idMesa);
	}

}
